
IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CP_Cbtes_Cpra_Generar_Asi') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CP_Cbtes_Cpra_Generar_Asi
END
GO

CREATE PROCEDURE [dbo].[CP_Cbtes_Cpra_Generar_Asi] 
@Id_Trans Int
AS 

SET NOCOUNT ON 
/*Declaracion Variables Locales*/
DECLARE @Signo	INT
		,@Compromete_Compras SMALLINT
		,@Id_Iva	CHAR(3)
		,@Alias_D SmallInt
		,@Alias_H SmallInt
		,@ID_Cta_Debe Int
		,@ID_Cta_Haber Int
		,@ID_Centro_Costo CHAR(10)
		,@IMP_GRAVADO DECIMAL(12,2)
		,@IMP_IVA DECIMAL(12,2)
		,@Id_Proveedor	INT
		,@Importe	DECIMAL(12,2)
		,@Fecha	DATETIME
		,@Id_Tipo_Cbte	CHAR(4)
		,@ASI_Comp_x_Items INT
		,@Alias_D_IVA INT 
		,@ID_Cta_Debe_IVA INT
		,@IMPORTE_NC DECIMAL(12,2)
        ,@NroItem SMALLINT
		,@Id_Tipo_Reten VARCHAR(10)

/*FIN Declaracion Variables Locales*/

DECLARE @Mensaje			VARCHAR(100),@Id_Trans_ND INT

BEGIN TRY
BEGIN TRAN

/*Asignacion Variables*/
SELECT @Fecha = Fecha
        ,@Id_Tipo_Cbte = Id_Tipo_Cbte
		,@Id_Proveedor = Id_Proveedor  
		,@Importe = Imp_TOTAL
		,@IMP_GRAVADO = Imp_Gravado + Imp_Gravado2 + Imp_Gravado3 + Imp_Exento
		,@IMP_IVA = Imp_Iva + Imp_Iva2 + Imp_Iva3
		FROM CBTES WHERE Id_Trans = @Id_Trans

SET @Compromete_Compras	= ISNULL((SELECT Compromete_Compras FROM Cbtes_Tipos WHERE Id_Tipo_Cbte = @Id_Tipo_Cbte), 0)
SET	@Id_Iva	= ISNULL((SELECT Id_Iva FROM Proveedores WHERE Id_Proveedor = @Id_Proveedor), 'I')
SET @Signo = @Compromete_Compras
SET @ASI_Comp_x_Items = CAST( dbo.CF_xParam('ASI_Comp_x_Items') AS INT)



SET @Alias_D = (SELECT Id_Cta_Contable_D FROM PROVEEDORES WHERE ID_PROVEEDOR = @ID_PROVEEDOR)
SET @Alias_H = (SELECT Id_Cta_Contable_H FROM PROVEEDORES WHERE ID_PROVEEDOR = @ID_PROVEEDOR)
SET @Alias_D_IVA = (select Valor_INTEGER from xParametros where setDatos= 1 and idParametro ='Cta_Iva_Cre_Loc')

SET @ID_Centro_Costo = (SELECT ID_Centro_Costo FROM PROVEEDORES WHERE ID_PROVEEDOR = @ID_PROVEEDOR)

SET @ID_Cta_Debe = (SELECT dbo.CF_Cta_Cont(@Alias_D, @Fecha))
SET @ID_Cta_Debe_IVA = (SELECT dbo.CF_Cta_Cont(@Alias_D_IVA, @Fecha))
SET @ID_Cta_Haber = (SELECT dbo.CF_Cta_Cont(@Alias_H, @Fecha))
SET @NroItem = 0
/*FIN Asignacion Variables*/

IF @Compromete_Compras = 0
	BEGIN
	    SET @Mensaje = 'No es un cbte de compra.'
		rollback
		SELECT	 1099		    	AS ErrorNumber 
				,0					AS ErrorSeverity  
				,0					AS ErrorState 
				,0					AS ErrorProcedure  
				,0					AS ErrorLine		
				,@Mensaje			AS ErrorMessage
		RETURN 1
	END

IF ISNULL(@ASI_Comp_x_Items,0) = 0          --Asiento por cabecerad e cbte.
	BEGIN
		IF @SIGNO > 0
			BEGIN	
			INSERT INTO Cbtes_Ctas_Contables (Id_Trans,	Id_Cta_Contable,	Fecha, Debe, Haber, Observacion, Alias, Id_Asiento, Id_Centro_Costo, Item)
									VALUES	(@Id_Trans,	@ID_Cta_Debe,	@Fecha,@IMP_GRAVADO,	0,	'',@Alias_D,0,	@ID_Centro_Costo,1)
			INSERT INTO Cbtes_Ctas_Contables (Id_Trans,	Id_Cta_Contable,	Fecha,Debe, Haber, Observacion,Alias, Id_Asiento, Id_Centro_Costo, Item)
									VALUES	(@Id_Trans,	@ID_Cta_Debe_IVA,	@Fecha,@IMP_IVA,	0,	'',@Alias_D_IVA,0,	@ID_Centro_Costo,2)
			INSERT INTO Cbtes_Ctas_Contables (Id_Trans,	Id_Cta_Contable,	Fecha,Debe, Haber, Observacion,Alias, Id_Asiento, Id_Centro_Costo, Item)
									VALUES	(@Id_Trans,	@ID_Cta_Haber,	@Fecha,0,	@Importe,	'',@Alias_H,0,	@ID_Centro_Costo,3)
			END	
		ELSE
			BEGIN
			SET @IMPORTE_NC = @IMPORTE*-1
			INSERT INTO Cbtes_Ctas_Contables (Id_Trans,	Id_Cta_Contable,	Fecha,Debe, Haber, Observacion,Alias, Id_Asiento, Id_Centro_Costo, Item)
										VALUES	(@Id_Trans,	@ID_Cta_Haber,	@Fecha,@Importe_NC,	0,	'',@Alias_H,0,	@ID_Centro_Costo,1)
			INSERT INTO Cbtes_Ctas_Contables (Id_Trans,	Id_Cta_Contable,	Fecha,Debe, Haber, Observacion,Alias, Id_Asiento, Id_Centro_Costo, Item)
										VALUES	(@Id_Trans,	@ID_Cta_Debe_IVA,	@Fecha,0,@IMP_IVA,	'',@Alias_D_IVA,0,	@ID_Centro_Costo,2)
			INSERT INTO Cbtes_Ctas_Contables (Id_Trans,	Id_Cta_Contable,	Fecha,Debe, Haber, Observacion,Alias, Id_Asiento, Id_Centro_Costo, Item)
										VALUES	(@Id_Trans,	@ID_Cta_DEBE,	@Fecha,0,	@Importe_NC-@IMP_IVA,	'',@Alias_D,0,	@ID_Centro_Costo,3)
			END
	END
Else
	BEGIN
		--PRINT 'Compromete Factura COMPRA
		/*INICIO Insert: Cuenta Contable: DEBE*/		
		PRINT 'Generacion de Items de Productos'

		DECLARE curGenCtaContDEBE CURSOR FOR 

	    	SELECT P.Id_Alias_Cta_Cont,isnull(P.Id_Centro_Costo,''),isnull(Sum(I.Imp_Gravado*@Signo),0)
	    	FROM Cbtes_Items i, Productos P
		    WHERE 
		    Id_Trans = @Id_Trans
	     	and I.id_Producto = P.Id_Producto
		    group by P.Id_Alias_Cta_Cont,P.Id_Centro_Costo

		    PRINT 'Generacion select del cursor'

		OPEN curGenCtaContDEBE
		FETCH NEXT FROM curGenCtaContDEBE INTO @Alias_D,@Id_Centro_Costo,@IMPORTE
		WHILE @@FETCH_STATUS = 0
		BEGIN
		    SET @ID_Cta_Debe = (SELECT dbo.CF_Cta_Cont(@Alias_D, @Fecha))
			SET @NroItem = @NroItem + 1
		
			PRINT 'Item: ' + CONVERT(VARCHAR(10), @NroItem) +  '. Alias: ' + CONVERT(VARCHAR(10), @Alias_D) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @ID_Cta_Debe) + '. Centro_Costo: ' + CONVERT(VARCHAR(10), @Id_Centro_Costo) 


					INSERT INTO Cbtes_Ctas_Contables
					(Id_Trans,		Id_Cta_Contable,	Fecha,
					Debe,			Haber,				Observacion,
					Alias,			Id_Asiento,			Id_Centro_Costo,
					Item)
					VALUES									
					(@Id_Trans,	@ID_Cta_Debe,	@Fecha,
					@Importe/*Debe*/,		0,				''/*Observacion*/,
					@Alias_D,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
					@NroItem)


		FETCH NEXT FROM curGenCtaContDEBE INTO  @Alias_D,@Id_Centro_Costo,@IMPORTE
		END 

		CLOSE curGenCtaContDEBE
		DEALLOCATE curGenCtaContDEBE

		/*FIN Insert: Cuenta Contable: DEBE*/
	
		PRINT 'Generacion de Items de Percepciones'	

		DECLARE curGenCtaCteDEBEPercep CURSOR FOR 
		SELECT DISTINCT Id_Tipo_Reten 
		FROM Cbtes_Reten 
		WHERE 
		Id_Trans = @Id_Trans

		OPEN curGenCtaCteDEBEPercep
		FETCH NEXT FROM curGenCtaCteDEBEPercep INTO @Id_Tipo_Reten
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SET @Alias_D = (SELECT Id_Cta_Contable FROM Cbtes_Reten_Tipos WHERE Id_Tipo_Reten = @Id_Tipo_Reten)
		    SET @ID_Cta_Debe = (SELECT dbo.CF_Cta_Cont(@Alias_D, @Fecha))
			SET @Id_Centro_Costo = ''
			SET @IMPORTE = (SELECT SUM(Importe) FROM Cbtes_Reten WHERE Id_Trans = @Id_Trans AND Id_Tipo_Reten = @Id_Tipo_Reten)
			SET @NroItem = @NroItem + 1
		
			--PRINT 'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Tipo_Reten: ' + @Id_Tipo_Reten + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable) + '. Centro_Costo: ' + CONVERT(VARCHAR(10), @Id_Centro_Costo) 
	
			INSERT INTO Cbtes_Ctas_Contables
			(Id_Trans,		Id_Cta_Contable,	Fecha,
			Debe,			Haber,				Observacion,
			Alias,			Id_Asiento,			Id_Centro_Costo,
			Item)
			VALUES									
			(@Id_Trans,	@ID_Cta_Debe,	@Fecha,
			@Importe/*Debe*/,		0,				''/*Observacion*/,
			@Alias_D,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
			@NroItem)

		FETCH NEXT FROM curGenCtaCteDEBEPercep INTO @Id_Tipo_Reten
		END 
		CLOSE curGenCtaCteDEBEPercep
		DEALLOCATE curGenCtaCteDEBEPercep
	
		--PRINT 'Generacion de Items de Iva'

		SET @Alias_D_IVA = (select Valor_INTEGER from xParametros where setDatos= 1 and idParametro ='Cta_Iva_Cre_Loc')
        SET @ID_Centro_Costo = ''
        SET @ID_Cta_Debe_IVA = (SELECT dbo.CF_Cta_Cont(@Alias_D_IVA, @Fecha))
	
		IF(@IMP_IVA <> 0)
		BEGIN
			SET @NroItem = @NroItem + 1
		
			--PRINT 'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable) + '. Centro_Costo: ' + CONVERT(VARCHAR(10), @Id_Centro_Costo) 
	
			INSERT INTO Cbtes_Ctas_Contables
			(Id_Trans,		Id_Cta_Contable,	Fecha,
			Debe,			Haber,				Observacion,
			Alias,			Id_Asiento,			Id_Centro_Costo,
			Item)
			VALUES									
			(@Id_Trans,	@ID_Cta_Debe_IVA,	@Fecha,
			@IMP_IVA/*Debe*/,		0,				''/*Observacion*/,
			@Alias_D_IVA,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
			@NroItem)		
		END

		/*Insert: Cuenta Contable: HABER */
		--PRINT 'Generacion Cuenta Contable: HABER'

		SELECT @Importe = Imp_TOTAL	FROM CBTES WHERE Id_Trans = @Id_Trans

		SET @Id_Centro_Costo = (SELECT Isnull(Id_Centro_Costo,'') FROM Proveedores WHERE Id_PROVEEDOR = @ID_PROVEEDOR)
		SET @NroItem = @NroItem + 1
		--PRINT 'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Alias: ' + CONVERT(VARCHAR(10), @Alias_H) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @ID_Cta_Haber) + '. Centro_Costo: ' + CONVERT(VARCHAR(10), @Id_Centro_Costo) 
	
		INSERT INTO Cbtes_Ctas_Contables
		(Id_Trans,		Id_Cta_Contable,	Fecha,
		Debe,			Haber,				Observacion,
		Alias,			Id_Asiento,			Id_Centro_Costo,
		Item)
		VALUES									
		(@Id_Trans,	@ID_Cta_Haber,	@Fecha,
		0,@Importe ,			''/*Observacion*/,
		@Alias_H,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
		@NroItem)
		/*FIN Insert: Cuenta Contable: DEBE (SI la Cond. Pago NO es Contado)*/
	
	
	/*Insert: Cuenta Contable: HABER*/
	--PRINT 'Generacion Cuenta Contable: HABER'
	
		--PRINT 'FIN Compromete COMPRAS'
	END /*IF(@Flag_Compromete_cOMPRAS = 1)*/


COMMIT
SELECT	 0					AS ErrorNumber 
		,0					AS ErrorSeverity  
		,0					AS ErrorState 
		,0					AS ErrorProcedure  
		,0					AS ErrorLine		
		,@Mensaje			AS ErrorMessage

END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo;  
	ROLLBACK
END CATCH;  

